/**
 * \file: svg_bitmap_decoder_err.h
 *
 * \version: $Id: svg_bitmap_decoder_err.h,v 1.12 2010/01/11 12:57:48 tkniep Exp $
 *
 * Error types for the Bitmap Decoder
 *
 * \component: SVG Bitmap Decoder (SVGBMPDEC)
 *
 * \author: T. Kniep (tkniep@de.adit-jv.com)
 *
 * \copyright: (c) 2009 ADIT Corporation
 *
 ***********************************************************************/
 
#ifndef SVG_BITMAP_DECODER_ERROR_H
#define SVG_BITMAP_DECODER_ERROR_H

#ifdef __cplusplus
extern "C" {
#endif

#include "svg_error.h"

typedef enum {
    SVG_BMPDEC_INVALID_CLIP = SVG_BITMAP_DEC_ERROR,
    SVG_BMPDEC_DEC_ERROR,
    SVG_BMPDEC_NO_DECODER,
    SVG_BMPDEC_BUSY,
    SVG_BMPDEC_INTERNAL_ERROR,
    SVG_BMPDEC_QUEUE_MAX,
    SVG_BMPDEC_OS_ERROR,
    SVG_BMPDEC_INVALID_CONTEXT,
    SVG_BMPDEC_CTX_MAX,
    SVG_BMPDEC_QUEUE_EMPTY
} TR_BMPDEC_ERROR;

typedef enum {
    SVGINITBMPDEC,
    SVGCLOSEBMPDEC,
    SVGCREATECONTEXTBMPDEC,
    SVGDESTROYCONTEXTBMPDEC,
    SVGGETIMAGEINFO,
    SVGGETBMPDECFORMATS,
    SVGDECODEIMAGE,
    SVGFLUSHBMPDEC,
    SVGFINISHBMPDEC,
    SVGWAITBMPDEC,
    SVGGETBMPDECERROR,
    GRL_BMPDEC_DRAW_IMAGE_DUMMY,
    GRL_BMPDEC_GET_IMAGE_INFO_DUMMY,
    GRL_BMPDEC_IS_TYPE_DUMMY,
    GRL_BMPDEC_INIT_TABLES,
    GRL_BMPDEC_REG_DECODER,
    GRL_BMPDEC_CHECK_MODE_SVG,
    GRL_BMPDEC_CHECK_MODE_MEM,
    GRL_BMPDEC_CHECK_IMG,
    GRL_BMPDEC_CHECK_IMG_BASIC,
    GRL_BMPDEC_GET_IMAGE_INFO,
    GRL_BMPDEC_GET_FORMATS,
    GRL_BMPDEC_DRAW_IMAGE_SYNC,
    GRL_BMPDEC_DRAW_IMAGE_ASYNC,
    GRL_BMPDEC_GET_ERROR,
    GRL_BMPDEC_SET_ERROR,
    GRL_BMPDEC_CLR_ERROR,
    GRL_BMPDEC_CLIPPING_SETUP,
    GRL_BMPDEC_DRAW_IMAGE_PNG,
    GRL_BMPDEC_GET_IMAGE_INFO_PNG,
    GRL_BMPDEC_IS_TYPE_PNG,
    GRL_BMPDEC_PNG_READ_FUNC,
    GRL_BMPDEC_PNG_READ_FUNC_ADVANCED,
    GRL_BMPDEC_PALETTE_REPLACE,
    GRL_BMPDEC_DRAW_IMAGE_JPEG,
    GRL_BMPDEC_GET_IMAGE_INFO_JPEG,
    GRL_BMPDEC_IS_TYPE_JPEG,
    GRL_BMPDEC_READ_CONF,
    GRL_BMPDEC_GET_CONF,
    GRL_BMPDEC_CLST_INIT,
    GRL_BMPDEC_CLST_UNINIT,
    GRL_BMPDEC_CLST_ADD,
    GRL_BMPDEC_CLST_DEL,
    GRL_BMPDEC_CLST_GET_CTX,
    GRL_BMPDEC_CLST_GET_NUM,
    GRL_BMPDEC_CRE_CTX,
    GRL_BMPDEC_DEC_TSK,
    GRL_BMPDEC_CRE_DEC_TSK,
    GRL_BMPDEC_PNG_DEST_SET,
    GRL_BMPDEC_DTY_CTX,
    GRL_BMPDEC_WAI_DEC,
    GRL_BMPDEC_DRAW_IMAGE_FGS,
    GRL_BMPDEC_GET_IMAGE_INFO_FGS
} TR_BMPDEC_FCT;

#ifdef __cplusplus
}
#endif


#endif /* SVG_BITMAP_DECODER_ERROR_H */
